overall_rating();

function overall_rating() {
    let template = Template.GetCurrent();
    /* Create a status object to track whether REPORTER Variables are all present and valid.
     * <success> is initially true but will be set to false if anything missing or invalid. */
    let status = { success: true, missing: [], invalid: [] };

    let head_score = get_variable_value(status, `HEAD_FINAL_SCORE`, "float");
    let neck_score = get_variable_value(status, `NECK_FINAL_SCORE`, "float");
    let chest_score = get_variable_value(status, `CHEST_ABDOMEN_FINAL_SCORE`, "float");
    let pelvis_and_lumbar_score = get_variable_value(status, `PELVIS_AND_LUMBAR_MODIFIER`, "float");

    let total_score = head_score + neck_score + chest_score + pelvis_and_lumbar_score;

    /** Check if capping limit is "TRUE" for any body region or head excursion zone
     * If it is then total score will automatically be zero. Add an asterisk to the score to indicate that it has been capped. */
    let overal_capping = "FALSE";
    for (let rep_var of Variable.GetAll(template)) {
        if (rep_var.name.endsWith("CAPPING_LIMIT") && rep_var.value == "TRUE") {
            total_score = "*0";
            overal_capping = "TRUE";
            break;
        }
    }

    /** create the "CAPPING_LIMIT" variable  */
    new Variable(template, `CAPPING_LIMIT`, "Capping Limit", overal_capping, "General", false, true);

    new Variable(
        template,
        "TOTAL_SCORE",
        "head + neck + chest & abdomen + pelvis & lumbar modifier (0 if any capping limit is TRUE)",
        total_score,
        "General",
        false,
        true
    );
    new Variable(template, "MAX_POSSIBLE_SCORE", "Maximum score for Far Side Assessment", "12", "General", false, true);

    let countermeasure = get_variable_value(status, `M1_STRUCTURE_HEAD_EXCURSION_COUNTERMEASURE_VALUE`, "int");
    if (countermeasure == 1) {
        new Variable(template, "COUNTERMEASURE", "Countermeasure", "Yes", "General", false, true);
    } else {
        new Variable(template, "COUNTERMEASURE", "Countermeasure", "No", "General", false, true);
    }
}
